unit frmMain;

//------------------------------------------------------------------------------
//     EventViewer Management Sample
//     This sample is originally inspired from a MSDN Sample with some additional
//     features.
//
//     This code is released to the Delphi .NET community
//     I accept no liabilities for damage, use at your own risk.
//
//     Written by: Dave Bhatia, Tara Group, Inc. dbhatia@taragroup.com
//------------------------------------------------------------------------------


interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Diagnostics;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    CreateLog: System.Windows.Forms.Button;
    WriteEntry: System.Windows.Forms.Button;
    VerifyLog: System.Windows.Forms.Button;
    RemoveSource: System.Windows.Forms.Button;
    ReadEntry: System.Windows.Forms.Button;
    VerifySource: System.Windows.Forms.Button;
    ClearLog: System.Windows.Forms.Button;
    DeleteLog: System.Windows.Forms.Button;
    EventLog1: System.Diagnostics.EventLog;
    LinkLabel1: System.Windows.Forms.LinkLabel;
    Label1: System.Windows.Forms.Label;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure CreateLog_Click(sender: System.Object; e: System.EventArgs);
    procedure ClearLog_Click(sender: System.Object; e: System.EventArgs);
    procedure VerifyLog_Click(sender: System.Object; e: System.EventArgs);
    procedure WriteEntry_Click(sender: System.Object; e: System.EventArgs);
    procedure DeleteLog_Click(sender: System.Object; e: System.EventArgs);
    procedure VerifySource_Click(sender: System.Object; e: System.EventArgs);
    procedure RemoveSource_Click(sender: System.Object; e: System.EventArgs);
    procedure ReadEntry_Click(sender: System.Object; e: System.EventArgs);
    procedure LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

implementation

{$R 'frmMain.TWinForm.resources'}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.CreateLog := System.Windows.Forms.Button.Create;
  Self.WriteEntry := System.Windows.Forms.Button.Create;
  Self.VerifyLog := System.Windows.Forms.Button.Create;
  Self.RemoveSource := System.Windows.Forms.Button.Create;
  Self.ReadEntry := System.Windows.Forms.Button.Create;
  Self.VerifySource := System.Windows.Forms.Button.Create;
  Self.ClearLog := System.Windows.Forms.Button.Create;
  Self.DeleteLog := System.Windows.Forms.Button.Create;
  Self.EventLog1 := System.Diagnostics.EventLog.Create;
  Self.LinkLabel1 := System.Windows.Forms.LinkLabel.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  (System.ComponentModel.ISupportInitialize(Self.EventLog1)).BeginInit;
  Self.SuspendLayout;
  // 
  // CreateLog
  // 
  Self.CreateLog.Location := System.Drawing.Point.Create(32, 32);
  Self.CreateLog.Name := 'CreateLog';
  Self.CreateLog.Size := System.Drawing.Size.Create(232, 23);
  Self.CreateLog.TabIndex := 0;
  Self.CreateLog.Text := 'Create Custom Log';
  Include(Self.CreateLog.Click, Self.CreateLog_Click);
  // 
  // WriteEntry
  // 
  Self.WriteEntry.Location := System.Drawing.Point.Create(32, 64);
  Self.WriteEntry.Name := 'WriteEntry';
  Self.WriteEntry.Size := System.Drawing.Size.Create(232, 23);
  Self.WriteEntry.TabIndex := 1;
  Self.WriteEntry.Text := 'Write Entry';
  Include(Self.WriteEntry.Click, Self.WriteEntry_Click);
  // 
  // VerifyLog
  // 
  Self.VerifyLog.Location := System.Drawing.Point.Create(32, 96);
  Self.VerifyLog.Name := 'VerifyLog';
  Self.VerifyLog.Size := System.Drawing.Size.Create(232, 23);
  Self.VerifyLog.TabIndex := 2;
  Self.VerifyLog.Text := 'Verify Log Exists';
  Include(Self.VerifyLog.Click, Self.VerifyLog_Click);
  // 
  // RemoveSource
  // 
  Self.RemoveSource.Location := System.Drawing.Point.Create(32, 128);
  Self.RemoveSource.Name := 'RemoveSource';
  Self.RemoveSource.Size := System.Drawing.Size.Create(232, 23);
  Self.RemoveSource.TabIndex := 3;
  Self.RemoveSource.Text := 'Remove Event Source';
  Include(Self.RemoveSource.Click, Self.RemoveSource_Click);
  // 
  // ReadEntry
  // 
  Self.ReadEntry.Location := System.Drawing.Point.Create(288, 128);
  Self.ReadEntry.Name := 'ReadEntry';
  Self.ReadEntry.Size := System.Drawing.Size.Create(232, 23);
  Self.ReadEntry.TabIndex := 7;
  Self.ReadEntry.Text := 'Read Entry';
  Include(Self.ReadEntry.Click, Self.ReadEntry_Click);
  // 
  // VerifySource
  // 
  Self.VerifySource.Location := System.Drawing.Point.Create(288, 96);
  Self.VerifySource.Name := 'VerifySource';
  Self.VerifySource.Size := System.Drawing.Size.Create(232, 23);
  Self.VerifySource.TabIndex := 6;
  Self.VerifySource.Text := 'Verify Source Exists';
  Include(Self.VerifySource.Click, Self.VerifySource_Click);
  // 
  // ClearLog
  // 
  Self.ClearLog.Location := System.Drawing.Point.Create(288, 64);
  Self.ClearLog.Name := 'ClearLog';
  Self.ClearLog.Size := System.Drawing.Size.Create(232, 23);
  Self.ClearLog.TabIndex := 5;
  Self.ClearLog.Text := 'Clear Log';
  Include(Self.ClearLog.Click, Self.ClearLog_Click);
  // 
  // DeleteLog
  // 
  Self.DeleteLog.Location := System.Drawing.Point.Create(288, 32);
  Self.DeleteLog.Name := 'DeleteLog';
  Self.DeleteLog.Size := System.Drawing.Size.Create(232, 23);
  Self.DeleteLog.TabIndex := 4;
  Self.DeleteLog.Text := 'Delete Log';
  Include(Self.DeleteLog.Click, Self.DeleteLog_Click);
  // 
  // EventLog1
  // 
  Self.EventLog1.SynchronizingObject := Self;
  // 
  // LinkLabel1
  // 
  Self.LinkLabel1.Location := System.Drawing.Point.Create(32, 176);
  Self.LinkLabel1.Name := 'LinkLabel1';
  Self.LinkLabel1.Size := System.Drawing.Size.Create(176, 23);
  Self.LinkLabel1.TabIndex := 9;
  Self.LinkLabel1.TabStop := True;
  Self.LinkLabel1.Text := 'Open Event Viewer to view Logs';
  Include(Self.LinkLabel1.LinkClicked, Self.LinkLabel1_LinkClicked);
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(216, 176);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(304, 16);
  Self.Label1.TabIndex := 10;
  Self.Label1.Text := 'Please re-open Event Viewer if your entry is not visible';
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(552, 214);
  Self.Controls.Add(Self.Label1);
  Self.Controls.Add(Self.LinkLabel1);
  Self.Controls.Add(Self.ReadEntry);
  Self.Controls.Add(Self.VerifySource);
  Self.Controls.Add(Self.ClearLog);
  Self.Controls.Add(Self.DeleteLog);
  Self.Controls.Add(Self.RemoveSource);
  Self.Controls.Add(Self.VerifyLog);
  Self.Controls.Add(Self.WriteEntry);
  Self.Controls.Add(Self.CreateLog);
  Self.Name := 'TWinForm';
  Self.Text := 'Event Viewer Log Management Sample';
  (System.ComponentModel.ISupportInitialize(Self.EventLog1)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
  System.Diagnostics.Process.Start('eventvwr.msc');
end;


procedure TWinForm.ReadEntry_Click(sender: System.Object; e: System.EventArgs);
var
 i:integer;
begin
  if (Self.eventLog1.Entries.Count > 0) then
    begin
      for i:=0 to EventLog1.Entries.Count-1 do
         MessageBox.Show( EventLog1.Entries.Item[i].Message );
    end
  else
    MessageBox.Show('There are no entries in the log.');
end;

procedure TWinForm.RemoveSource_Click(sender: System.Object; e: System.EventArgs);
begin
  if System.Diagnostics.EventLog.SourceExists('Source1') then
    System.Diagnostics.EventLog.DeleteEventSource('Source1');
end;

procedure TWinForm.VerifySource_Click(sender: System.Object; e: System.EventArgs);
var
  sourceExists: Boolean;
begin
  sourceExists := System.Diagnostics.EventLog.SourceExists('Source1');
  MessageBox.Show(('Does the source exist? ' + sourceExists.ToString));
end;

procedure TWinForm.DeleteLog_Click(sender: System.Object; e: System.EventArgs);
begin
   if System.Diagnostics.EventLog.Exists('NewLog1') then
    System.Diagnostics.EventLog.Delete('NewLog1'); 
end;

procedure TWinForm.WriteEntry_Click(sender: System.Object; e: System.EventArgs);
begin
  Self.eventLog1.WriteEntry('This is an informational message');
  Self.eventLog1.WriteEntry('This is an error message', System.Diagnostics.EventLogEntryType.Error);
end;

procedure TWinForm.VerifyLog_Click(sender: System.Object; e: System.EventArgs);
var
  logExists: Boolean;
begin
  logExists := System.Diagnostics.EventLog.Exists('NewLog1');
  MessageBox.Show(('Does the log exist? ' + logExists.ToString));
end;

procedure TWinForm.ClearLog_Click(sender: System.Object; e: System.EventArgs);
begin
    Self.eventLog1.Clear;
end;

procedure TWinForm.CreateLog_Click(sender: System.Object; e: System.EventArgs);
begin
  if System.Diagnostics.EventLog.SourceExists('Source1') then
    System.Diagnostics.EventLog.DeleteEventSource('Source1');
  System.Diagnostics.EventLog.CreateEventSource('Source1', 'NewLog1');
  Self.eventLog1.Log := 'NewLog1';
  Self.eventLog1.Source := 'Source1';
end;

end.
